
<?php
if(isset($errors)) {
    foreach($errors as $error) {
        print "<p class=\"error_block\">$error</p>";
    }
}
?>

<form method="POST" class="clearfix">
    <p class="legend_name"><?=$lang->backend_settings?></p>
    <div class="wrap_form">
    <div class="row">
        <div class="col-6">
            <div class=" mb-1">
                <label class=""><?=$lang->user_login?></label>
                <input class="form_input" type="text" name="user_login" value="" placeholder="" required>
            </div>
        </div>
        <div class="col-6">
            <div class=" mb-1">
                <label class=""><?=$lang->user_pass?></label>
                <input class="form_input" type="text" name="user_pass" value="" placeholder="" required>
            </div>
        </div>

        <div class="col-6">
            <div class=" mb-1">
                <label><?=$lang->user_email?> <span class="hint-bottom-middle-t-info-s-small-mobile  hint-anim" data-hint="<?=$lang->user_email_title?>">
                    <svg width="13px" height="13px" viewBox="0 0 438.533 438.533">
                        <path fill="#545454" d="M409.133,109.203c-19.608-33.592-46.205-60.189-79.798-79.796C295.736,9.801,259.058,0,219.273,0
                        c-39.781,0-76.47,9.801-110.063,29.407c-33.595,19.604-60.192,46.201-79.8,79.796C9.801,142.8,0,179.489,0,219.267
                        c0,39.78,9.804,76.463,29.407,110.062c19.607,33.592,46.204,60.189,79.799,79.798c33.597,19.605,70.283,29.407,110.063,29.407
                        s76.47-9.802,110.065-29.407c33.593-19.602,60.189-46.206,79.795-79.798c19.603-33.596,29.403-70.284,29.403-110.062
                        C438.533,179.485,428.732,142.795,409.133,109.203z M255.82,356.309c0,2.662-0.862,4.853-2.573,6.563
                        c-1.704,1.711-3.895,2.567-6.557,2.567h-54.823c-2.664,0-4.854-0.856-6.567-2.567c-1.714-1.711-2.57-3.901-2.57-6.563v-54.823
                        c0-2.662,0.855-4.853,2.57-6.563c1.713-1.708,3.903-2.563,6.567-2.563h54.823c2.662,0,4.853,0.855,6.557,2.563
                        c1.711,1.711,2.573,3.901,2.573,6.563V356.309z M325.338,187.574c-2.382,7.043-5.044,12.804-7.994,17.275
                        c-2.949,4.473-7.187,9.042-12.709,13.703c-5.51,4.663-9.891,7.996-13.135,9.998c-3.23,1.995-7.898,4.713-13.982,8.135
                        c-6.283,3.613-11.465,8.326-15.555,14.134c-4.093,5.804-6.139,10.513-6.139,14.126c0,2.67-0.862,4.859-2.574,6.571
                        c-1.707,1.711-3.897,2.566-6.56,2.566h-54.82c-2.664,0-4.854-0.855-6.567-2.566c-1.715-1.712-2.568-3.901-2.568-6.571v-10.279
                        c0-12.752,4.993-24.701,14.987-35.832c9.994-11.136,20.986-19.368,32.979-24.698c9.13-4.186,15.604-8.47,19.41-12.847
                        c3.812-4.377,5.715-10.188,5.715-17.417c0-6.283-3.572-11.897-10.711-16.849c-7.139-4.947-15.27-7.421-24.409-7.421
                        c-9.9,0-18.082,2.285-24.555,6.855c-6.283,4.565-14.465,13.322-24.554,26.263c-1.713,2.286-4.093,3.431-7.139,3.431
                        c-2.284,0-4.093-0.57-5.424-1.709L121.35,145.89c-4.377-3.427-5.138-7.422-2.286-11.991
                        c24.366-40.542,59.672-60.813,105.922-60.813c16.563,0,32.744,3.903,48.541,11.708c15.796,7.801,28.979,18.842,39.546,33.119
                        c10.554,14.272,15.845,29.787,15.845,46.537C328.904,172.824,327.71,180.529,325.338,187.574z"/>
                    </svg>
                </span></label>
                <input class="form_input" type="text" name="user_email" value="" required>
            </div>
        </div>

        <div class="col-6">
            <div class=" mb-1">
                 <label><?=$lang->backend_lang?></label>
                <select name="backend_lang" class="form_input">
                    <?php foreach ($backend_langs as $label=>$name) {
                        print "<option value='{$label}'>{$name}</option>";
                    }?>
                </select>
            </div>
        </div>
    </div>
    </div>



<p class="legend_name"><?=$lang->front_settings?> <span class="hint-bottom-middle-t-info-s-small-mobile  hint-anim" data-hint="<?=$lang->front_settings_title?>">
    <svg width="13px" height="13px" viewBox="0 0 438.533 438.533">
        <path fill="#545454" d="M409.133,109.203c-19.608-33.592-46.205-60.189-79.798-79.796C295.736,9.801,259.058,0,219.273,0
        c-39.781,0-76.47,9.801-110.063,29.407c-33.595,19.604-60.192,46.201-79.8,79.796C9.801,142.8,0,179.489,0,219.267
        c0,39.78,9.804,76.463,29.407,110.062c19.607,33.592,46.204,60.189,79.799,79.798c33.597,19.605,70.283,29.407,110.063,29.407
        s76.47-9.802,110.065-29.407c33.593-19.602,60.189-46.206,79.795-79.798c19.603-33.596,29.403-70.284,29.403-110.062
        C438.533,179.485,428.732,142.795,409.133,109.203z M255.82,356.309c0,2.662-0.862,4.853-2.573,6.563
        c-1.704,1.711-3.895,2.567-6.557,2.567h-54.823c-2.664,0-4.854-0.856-6.567-2.567c-1.714-1.711-2.57-3.901-2.57-6.563v-54.823
        c0-2.662,0.855-4.853,2.57-6.563c1.713-1.708,3.903-2.563,6.567-2.563h54.823c2.662,0,4.853,0.855,6.557,2.563
        c1.711,1.711,2.573,3.901,2.573,6.563V356.309z M325.338,187.574c-2.382,7.043-5.044,12.804-7.994,17.275
        c-2.949,4.473-7.187,9.042-12.709,13.703c-5.51,4.663-9.891,7.996-13.135,9.998c-3.23,1.995-7.898,4.713-13.982,8.135
        c-6.283,3.613-11.465,8.326-15.555,14.134c-4.093,5.804-6.139,10.513-6.139,14.126c0,2.67-0.862,4.859-2.574,6.571
        c-1.707,1.711-3.897,2.566-6.56,2.566h-54.82c-2.664,0-4.854-0.855-6.567-2.566c-1.715-1.712-2.568-3.901-2.568-6.571v-10.279
        c0-12.752,4.993-24.701,14.987-35.832c9.994-11.136,20.986-19.368,32.979-24.698c9.13-4.186,15.604-8.47,19.41-12.847
        c3.812-4.377,5.715-10.188,5.715-17.417c0-6.283-3.572-11.897-10.711-16.849c-7.139-4.947-15.27-7.421-24.409-7.421
        c-9.9,0-18.082,2.285-24.555,6.855c-6.283,4.565-14.465,13.322-24.554,26.263c-1.713,2.286-4.093,3.431-7.139,3.431
        c-2.284,0-4.093-0.57-5.424-1.709L121.35,145.89c-4.377-3.427-5.138-7.422-2.286-11.991
        c24.366-40.542,59.672-60.813,105.922-60.813c16.563,0,32.744,3.903,48.541,11.708c15.796,7.801,28.979,18.842,39.546,33.119
        c10.554,14.272,15.845,29.787,15.845,46.537C328.904,172.824,327.71,180.529,325.338,187.574z"/>
    </svg>
</span></p>
    <div class="wrap_form">

    <div class="row">
            <div class="col-6">
                <div class=" mb-1">
                    <label class=""><?=$lang->site_name?></label>
                    <input class="form_input" type="text" name="site_name" value="">
                </div>
            </div>

            <div class="col-6">
                <div class=" mb-1">
                    <label class=""><?=$lang->notify_email?> <span class="hint-bottom-middle-t-info-s-small-mobile  hint-anim" data-hint="<?=$lang->notify_email_title?>">
                        <svg width="13px" height="13px" viewBox="0 0 438.533 438.533">
                                                <path fill="#545454" d="M409.133,109.203c-19.608-33.592-46.205-60.189-79.798-79.796C295.736,9.801,259.058,0,219.273,0
                                                c-39.781,0-76.47,9.801-110.063,29.407c-33.595,19.604-60.192,46.201-79.8,79.796C9.801,142.8,0,179.489,0,219.267
                                                c0,39.78,9.804,76.463,29.407,110.062c19.607,33.592,46.204,60.189,79.799,79.798c33.597,19.605,70.283,29.407,110.063,29.407
                                                s76.47-9.802,110.065-29.407c33.593-19.602,60.189-46.206,79.795-79.798c19.603-33.596,29.403-70.284,29.403-110.062
                                                C438.533,179.485,428.732,142.795,409.133,109.203z M255.82,356.309c0,2.662-0.862,4.853-2.573,6.563
                                                c-1.704,1.711-3.895,2.567-6.557,2.567h-54.823c-2.664,0-4.854-0.856-6.567-2.567c-1.714-1.711-2.57-3.901-2.57-6.563v-54.823
                                                c0-2.662,0.855-4.853,2.57-6.563c1.713-1.708,3.903-2.563,6.567-2.563h54.823c2.662,0,4.853,0.855,6.557,2.563
                                                c1.711,1.711,2.573,3.901,2.573,6.563V356.309z M325.338,187.574c-2.382,7.043-5.044,12.804-7.994,17.275
                                                c-2.949,4.473-7.187,9.042-12.709,13.703c-5.51,4.663-9.891,7.996-13.135,9.998c-3.23,1.995-7.898,4.713-13.982,8.135
                                                c-6.283,3.613-11.465,8.326-15.555,14.134c-4.093,5.804-6.139,10.513-6.139,14.126c0,2.67-0.862,4.859-2.574,6.571
                                                c-1.707,1.711-3.897,2.566-6.56,2.566h-54.82c-2.664,0-4.854-0.855-6.567-2.566c-1.715-1.712-2.568-3.901-2.568-6.571v-10.279
                                                c0-12.752,4.993-24.701,14.987-35.832c9.994-11.136,20.986-19.368,32.979-24.698c9.13-4.186,15.604-8.47,19.41-12.847
                                                c3.812-4.377,5.715-10.188,5.715-17.417c0-6.283-3.572-11.897-10.711-16.849c-7.139-4.947-15.27-7.421-24.409-7.421
                                                c-9.9,0-18.082,2.285-24.555,6.855c-6.283,4.565-14.465,13.322-24.554,26.263c-1.713,2.286-4.093,3.431-7.139,3.431
                                                c-2.284,0-4.093-0.57-5.424-1.709L121.35,145.89c-4.377-3.427-5.138-7.422-2.286-11.991
                                                c24.366-40.542,59.672-60.813,105.922-60.813c16.563,0,32.744,3.903,48.541,11.708c15.796,7.801,28.979,18.842,39.546,33.119
                                                c10.554,14.272,15.845,29.787,15.845,46.537C328.904,172.824,327.71,180.529,325.338,187.574z"/>
                                            </svg>
                    </span></label>
                    <input class="form_input" type="text" name="notify_email" value="">
                </div>
            </div>
             <div class="col-6">
                <div class=" mb-1">
                    <label class=""><?=$lang->main_currency?></label>
                    <select name="main_currency" class="form_input">
                        <?php foreach ($site_currencies as $currency) {
                            print "<option value='{$currency->id}'>{$currency->name}</option>";
                        }?>
                    </select>
                </div>
            </div>

             <div class="col-6">
                <div class=" mb-1">
                    <label class=""><?=$lang->main_language?></label>
                    <select name="main_language" class="form_input">
                        <?php foreach ($site_langs as $language) {
                            print "<option value='{$language->id}'>{$language->name}</option>";
                        }?>
                    </select>
                </div>
            </div>
        
            <div class="col-6">
                <div class=" mb-1">
                    <label class=""><?=$lang->phone_default_region?><span class="hint-bottom-middle-t-info-s-small-mobile  hint-anim" data-hint="<?=$lang->phone_default_region_title?>">
                            <svg width="13px" height="13px" viewBox="0 0 438.533 438.533">
                                <path fill="#545454" d="M409.133,109.203c-19.608-33.592-46.205-60.189-79.798-79.796C295.736,9.801,259.058,0,219.273,0
                                c-39.781,0-76.47,9.801-110.063,29.407c-33.595,19.604-60.192,46.201-79.8,79.796C9.801,142.8,0,179.489,0,219.267
                                c0,39.78,9.804,76.463,29.407,110.062c19.607,33.592,46.204,60.189,79.799,79.798c33.597,19.605,70.283,29.407,110.063,29.407
                                s76.47-9.802,110.065-29.407c33.593-19.602,60.189-46.206,79.795-79.798c19.603-33.596,29.403-70.284,29.403-110.062
                                C438.533,179.485,428.732,142.795,409.133,109.203z M255.82,356.309c0,2.662-0.862,4.853-2.573,6.563
                                c-1.704,1.711-3.895,2.567-6.557,2.567h-54.823c-2.664,0-4.854-0.856-6.567-2.567c-1.714-1.711-2.57-3.901-2.57-6.563v-54.823
                                c0-2.662,0.855-4.853,2.57-6.563c1.713-1.708,3.903-2.563,6.567-2.563h54.823c2.662,0,4.853,0.855,6.557,2.563
                                c1.711,1.711,2.573,3.901,2.573,6.563V356.309z M325.338,187.574c-2.382,7.043-5.044,12.804-7.994,17.275
                                c-2.949,4.473-7.187,9.042-12.709,13.703c-5.51,4.663-9.891,7.996-13.135,9.998c-3.23,1.995-7.898,4.713-13.982,8.135
                                c-6.283,3.613-11.465,8.326-15.555,14.134c-4.093,5.804-6.139,10.513-6.139,14.126c0,2.67-0.862,4.859-2.574,6.571
                                c-1.707,1.711-3.897,2.566-6.56,2.566h-54.82c-2.664,0-4.854-0.855-6.567-2.566c-1.715-1.712-2.568-3.901-2.568-6.571v-10.279
                                c0-12.752,4.993-24.701,14.987-35.832c9.994-11.136,20.986-19.368,32.979-24.698c9.13-4.186,15.604-8.47,19.41-12.847
                                c3.812-4.377,5.715-10.188,5.715-17.417c0-6.283-3.572-11.897-10.711-16.849c-7.139-4.947-15.27-7.421-24.409-7.421
                                c-9.9,0-18.082,2.285-24.555,6.855c-6.283,4.565-14.465,13.322-24.554,26.263c-1.713,2.286-4.093,3.431-7.139,3.431
                                c-2.284,0-4.093-0.57-5.424-1.709L121.35,145.89c-4.377-3.427-5.138-7.422-2.286-11.991
                                c24.366-40.542,59.672-60.813,105.922-60.813c16.563,0,32.744,3.903,48.541,11.708c15.796,7.801,28.979,18.842,39.546,33.119
                                c10.554,14.272,15.845,29.787,15.845,46.537C328.904,172.824,327.71,180.529,325.338,187.574z"/>
                            </svg>
                    </span></label>
                    <select name="phone_default_region" class="form_input">
                        <option value="UA"><?=$lang->country_UA?> (UA)</option>
                        <option value="RU"><?=$lang->country_RU?> (RU)</option>
                        <option value="GE"><?=$lang->country_GE?> (GE)</option>
                        <option value="US"><?=$lang->country_US?> (US)</option>
                        <option value="AG"><?=$lang->country_AG?> (AG)</option>
                        <option value="AI"><?=$lang->country_AI?> (AI)</option>
                        <option value="AS"><?=$lang->country_AS?> (AS)</option>
                        <option value="BB"><?=$lang->country_BB?> (BB)</option>
                        <option value="BM"><?=$lang->country_BM?> (BM)</option>
                        <option value="BS"><?=$lang->country_BS?> (BS)</option>
                        <option value="CA"><?=$lang->country_CA?> (CA)</option>
                        <option value="DM"><?=$lang->country_DM?> (DM)</option>
                        <option value="DO"><?=$lang->country_DO?> (DO)</option>
                        <option value="GD"><?=$lang->country_GD?> (GD)</option>
                        <option value="GU"><?=$lang->country_GU?> (GU)</option>
                        <option value="JM"><?=$lang->country_JM?> (JM)</option>
                        <option value="KN"><?=$lang->country_KN?> (KN)</option>
                        <option value="KY"><?=$lang->country_KY?> (KY)</option>
                        <option value="LC"><?=$lang->country_LC?> (LC)</option>
                        <option value="MP"><?=$lang->country_MP?> (MP)</option>
                        <option value="MS"><?=$lang->country_MS?> (MS)</option>
                        <option value="PR"><?=$lang->country_PR?> (PR)</option>
                        <option value="SX"><?=$lang->country_SX?> (SX)</option>
                        <option value="TC"><?=$lang->country_TC?> (TC)</option>
                        <option value="TT"><?=$lang->country_TT?> (TT)</option>
                        <option value="VC"><?=$lang->country_VC?> (VC)</option>
                        <option value="VG"><?=$lang->country_VG?> (VG)</option>
                        <option value="VI"><?=$lang->country_VI?> (VI)</option>
                        <option value="KZ"><?=$lang->country_KZ?> (KZ)</option>
                        <option value="EG"><?=$lang->country_EG?> (EG)</option>
                        <option value="ZA"><?=$lang->country_ZA?> (ZA)</option>
                        <option value="GR"><?=$lang->country_GR?> (GR)</option>
                        <option value="NL"><?=$lang->country_NL?> (NL)</option>
                        <option value="BE"><?=$lang->country_BE?> (BE)</option>
                        <option value="FR"><?=$lang->country_FR?> (FR)</option>
                        <option value="ES"><?=$lang->country_ES?> (ES)</option>
                        <option value="HU"><?=$lang->country_HU?> (HU)</option>
                        <option value="IT"><?=$lang->country_IT?> (IT)</option>
                        <option value="VA"><?=$lang->country_VA?> (VA)</option>
                        <option value="RO"><?=$lang->country_RO?> (RO)</option>
                        <option value="CH"><?=$lang->country_CH?> (CH)</option>
                        <option value="AT"><?=$lang->country_AT?> (AT)</option>
                        <option value="GB"><?=$lang->country_GB?> (GB)</option>
                        <option value="GG"><?=$lang->country_GG?> (GG)</option>
                        <option value="IM"><?=$lang->country_IM?> (IM)</option>
                        <option value="JE"><?=$lang->country_JE?> (JE)</option>
                        <option value="DK"><?=$lang->country_DK?> (DK)</option>
                        <option value="SE"><?=$lang->country_SE?> (SE)</option>
                        <option value="NO"><?=$lang->country_NO?> (NO)</option>
                        <option value="SJ"><?=$lang->country_SJ?> (SJ)</option>
                        <option value="PL"><?=$lang->country_PL?> (PL)</option>
                        <option value="DE"><?=$lang->country_DE?> (DE)</option>
                        <option value="PE"><?=$lang->country_PE?> (PE)</option>
                        <option value="MX"><?=$lang->country_MX?> (MX)</option>
                        <option value="CU"><?=$lang->country_CU?> (CU)</option>
                        <option value="AR"><?=$lang->country_AR?> (AR)</option>
                        <option value="BR"><?=$lang->country_BR?> (BR)</option>
                        <option value="CL"><?=$lang->country_CL?> (CL)</option>
                        <option value="CO"><?=$lang->country_CO?> (CO)</option>
                        <option value="VE"><?=$lang->country_VE?> (VE)</option>
                        <option value="MY"><?=$lang->country_MY?> (MY)</option>
                        <option value="AU"><?=$lang->country_AU?> (AU)</option>
                        <option value="CC"><?=$lang->country_CC?> (CC)</option>
                        <option value="CX"><?=$lang->country_CX?> (CX)</option>
                        <option value="ID"><?=$lang->country_ID?> (ID)</option>
                        <option value="PH"><?=$lang->country_PH?> (PH)</option>
                        <option value="NZ"><?=$lang->country_NZ?> (NZ)</option>
                        <option value="SG"><?=$lang->country_SG?> (SG)</option>
                        <option value="TH"><?=$lang->country_TH?> (TH)</option>
                        <option value="JP"><?=$lang->country_JP?> (JP)</option>
                        <option value="KR"><?=$lang->country_KR?> (KR)</option>
                        <option value="VN"><?=$lang->country_VN?> (VN)</option>
                        <option value="CN"><?=$lang->country_CN?> (CN)</option>
                        <option value="TR"><?=$lang->country_TR?> (TR)</option>
                        <option value="IN"><?=$lang->country_IN?> (IN)</option>
                        <option value="PK"><?=$lang->country_PK?> (PK)</option>
                        <option value="AF"><?=$lang->country_AF?> (AF)</option>
                        <option value="LK"><?=$lang->country_LK?> (LK)</option>
                        <option value="MM"><?=$lang->country_MM?> (MM)</option>
                        <option value="IR"><?=$lang->country_IR?> (IR)</option>
                        <option value="SS"><?=$lang->country_SS?> (SS)</option>
                        <option value="MA"><?=$lang->country_MA?> (MA)</option>
                        <option value="EH"><?=$lang->country_EH?> (EH)</option>
                        <option value="DZ"><?=$lang->country_DZ?> (DZ)</option>
                        <option value="TN"><?=$lang->country_TN?> (TN)</option>
                        <option value="LY"><?=$lang->country_LY?> (LY)</option>
                        <option value="GM"><?=$lang->country_GM?> (GM)</option>
                        <option value="SN"><?=$lang->country_SN?> (SN)</option>
                        <option value="MR"><?=$lang->country_MR?> (MR)</option>
                        <option value="ML"><?=$lang->country_ML?> (ML)</option>
                        <option value="GN"><?=$lang->country_GN?> (GN)</option>
                        <option value="CI"><?=$lang->country_CI?> (CI)</option>
                        <option value="BF"><?=$lang->country_BF?> (BF)</option>
                        <option value="NE"><?=$lang->country_NE?> (NE)</option>
                        <option value="TG"><?=$lang->country_TG?> (TG)</option>
                        <option value="BJ"><?=$lang->country_BJ?> (BJ)</option>
                        <option value="MU"><?=$lang->country_MU?> (MU)</option>
                        <option value="LR"><?=$lang->country_LR?> (LR)</option>
                        <option value="SL"><?=$lang->country_SL?> (SL)</option>
                        <option value="GH"><?=$lang->country_GH?> (GH)</option>
                        <option value="NG"><?=$lang->country_NG?> (NG)</option>
                        <option value="TD"><?=$lang->country_TD?> (TD)</option>
                        <option value="CF"><?=$lang->country_CF?> (CF)</option>
                        <option value="CM"><?=$lang->country_CM?> (CM)</option>
                        <option value="CV"><?=$lang->country_CV?> (CV)</option>
                        <option value="ST"><?=$lang->country_ST?> (ST)</option>
                        <option value="GQ"><?=$lang->country_GQ?> (GQ)</option>
                        <option value="GA"><?=$lang->country_GA?> (GA)</option>
                        <option value="CG"><?=$lang->country_CG?> (CG)</option>
                        <option value="CD"><?=$lang->country_CD?> (CD)</option>
                        <option value="AO"><?=$lang->country_AO?> (AO)</option>
                        <option value="GW"><?=$lang->country_GW?> (GW)</option>
                        <option value="IO"><?=$lang->country_IO?> (IO)</option>
                        <option value="AC"><?=$lang->country_AC?> (AC)</option>
                        <option value="SC"><?=$lang->country_SC?> (SC)</option>
                        <option value="SD"><?=$lang->country_SD?> (SD)</option>
                        <option value="RW"><?=$lang->country_RW?> (RW)</option>
                        <option value="ET"><?=$lang->country_ET?> (ET)</option>
                        <option value="SO"><?=$lang->country_SO?> (SO)</option>
                        <option value="DJ"><?=$lang->country_DJ?> (DJ)</option>
                        <option value="KE"><?=$lang->country_KE?> (KE)</option>
                        <option value="TZ"><?=$lang->country_TZ?> (TZ)</option>
                        <option value="UG"><?=$lang->country_UG?> (UG)</option>
                        <option value="BI"><?=$lang->country_BI?> (BI)</option>
                        <option value="MZ"><?=$lang->country_MZ?> (MZ)</option>
                        <option value="ZM"><?=$lang->country_ZM?> (ZM)</option>
                        <option value="MG"><?=$lang->country_MG?> (MG)</option>
                        <option value="RE"><?=$lang->country_RE?> (RE)</option>
                        <option value="YT"><?=$lang->country_YT?> (YT)</option>
                        <option value="ZW"><?=$lang->country_ZW?> (ZW)</option>
                        <option value="NA"><?=$lang->country_NA?> (NA)</option>
                        <option value="MW"><?=$lang->country_MW?> (MW)</option>
                        <option value="LS"><?=$lang->country_LS?> (LS)</option>
                        <option value="BW"><?=$lang->country_BW?> (BW)</option>
                        <option value="SZ"><?=$lang->country_SZ?> (SZ)</option>
                        <option value="KM"><?=$lang->country_KM?> (KM)</option>
                        <option value="SH"><?=$lang->country_SH?> (SH)</option>
                        <option value="TA"><?=$lang->country_TA?> (TA)</option>
                        <option value="ER"><?=$lang->country_ER?> (ER)</option>
                        <option value="AW"><?=$lang->country_AW?> (AW)</option>
                        <option value="FO"><?=$lang->country_FO?> (FO)</option>
                        <option value="GL"><?=$lang->country_GL?> (GL)</option>
                        <option value="GI"><?=$lang->country_GI?> (GI)</option>
                        <option value="PT"><?=$lang->country_PT?> (PT)</option>
                        <option value="LU"><?=$lang->country_LU?> (LU)</option>
                        <option value="IE"><?=$lang->country_IE?> (IE)</option>
                        <option value="IS"><?=$lang->country_IS?> (IS)</option>
                        <option value="AL"><?=$lang->country_AL?> (AL)</option>
                        <option value="MT"><?=$lang->country_MT?> (MT)</option>
                        <option value="CY"><?=$lang->country_CY?> (CY)</option>
                        <option value="FI"><?=$lang->country_FI?> (FI)</option>
                        <option value="AX"><?=$lang->country_AX?> (AX)</option>
                        <option value="BG"><?=$lang->country_BG?> (BG)</option>
                        <option value="LT"><?=$lang->country_LT?> (LT)</option>
                        <option value="LV"><?=$lang->country_LV?> (LV)</option>
                        <option value="EE"><?=$lang->country_EE?> (EE)</option>
                        <option value="MD"><?=$lang->country_MD?> (MD)</option>
                        <option value="AM"><?=$lang->country_AM?> (AM)</option>
                        <option value="BY"><?=$lang->country_BY?> (BY)</option>
                        <option value="AD"><?=$lang->country_AD?> (AD)</option>
                        <option value="MC"><?=$lang->country_MC?> (MC)</option>
                        <option value="SM"><?=$lang->country_SM?> (SM)</option>
                        <option value="RS"><?=$lang->country_RS?> (RS)</option>
                        <option value="ME"><?=$lang->country_ME?> (ME)</option>
                        <option value="XK"><?=$lang->country_XK?> (XK)</option>
                        <option value="HR"><?=$lang->country_HR?> (HR)</option>
                        <option value="SI"><?=$lang->country_SI?> (SI)</option>
                        <option value="BA"><?=$lang->country_BA?> (BA)</option>
                        <option value="MK"><?=$lang->country_MK?> (MK)</option>
                        <option value="CZ"><?=$lang->country_CZ?> (CZ)</option>
                        <option value="SK"><?=$lang->country_SK?> (SK)</option>
                        <option value="LI"><?=$lang->country_LI?> (LI)</option>
                        <option value="FK"><?=$lang->country_FK?> (FK)</option>
                        <option value="BZ"><?=$lang->country_BZ?> (BZ)</option>
                        <option value="GT"><?=$lang->country_GT?> (GT)</option>
                        <option value="SV"><?=$lang->country_SV?> (SV)</option>
                        <option value="HN"><?=$lang->country_HN?> (HN)</option>
                        <option value="NI"><?=$lang->country_NI?> (NI)</option>
                        <option value="CR"><?=$lang->country_CR?> (CR)</option>
                        <option value="PA"><?=$lang->country_PA?> (PA)</option>
                        <option value="PM"><?=$lang->country_PM?> (PM)</option>
                        <option value="HT"><?=$lang->country_HT?> (HT)</option>
                        <option value="GP"><?=$lang->country_GP?> (GP)</option>
                        <option value="BL"><?=$lang->country_BL?> (BL)</option>
                        <option value="MF"><?=$lang->country_MF?> (MF)</option>
                        <option value="BO"><?=$lang->country_BO?> (BO)</option>
                        <option value="GY"><?=$lang->country_GY?> (GY)</option>
                        <option value="EC"><?=$lang->country_EC?> (EC)</option>
                        <option value="GF"><?=$lang->country_GF?> (GF)</option>
                        <option value="PY"><?=$lang->country_PY?> (PY)</option>
                        <option value="MQ"><?=$lang->country_MQ?> (MQ)</option>
                        <option value="SR"><?=$lang->country_SR?> (SR)</option>
                        <option value="UY"><?=$lang->country_UY?> (UY)</option>
                        <option value="CW"><?=$lang->country_CW?> (CW)</option>
                        <option value="BQ"><?=$lang->country_BQ?> (BQ)</option>
                        <option value="TL"><?=$lang->country_TL?> (TL)</option>
                        <option value="NF"><?=$lang->country_NF?> (NF)</option>
                        <option value="BN"><?=$lang->country_BN?> (BN)</option>
                        <option value="NR"><?=$lang->country_NR?> (NR)</option>
                        <option value="PG"><?=$lang->country_PG?> (PG)</option>
                        <option value="TO"><?=$lang->country_TO?> (TO)</option>
                        <option value="SB"><?=$lang->country_SB?> (SB)</option>
                        <option value="VU"><?=$lang->country_VU?> (VU)</option>
                        <option value="FJ"><?=$lang->country_FJ?> (FJ)</option>
                        <option value="PW"><?=$lang->country_PW?> (PW)</option>
                        <option value="WF"><?=$lang->country_WF?> (WF)</option>
                        <option value="CK"><?=$lang->country_CK?> (CK)</option>
                        <option value="NU"><?=$lang->country_NU?> (NU)</option>
                        <option value="WS"><?=$lang->country_WS?> (WS)</option>
                        <option value="KI"><?=$lang->country_KI?> (KI)</option>
                        <option value="NC"><?=$lang->country_NC?> (NC)</option>
                        <option value="TV"><?=$lang->country_TV?> (TV)</option>
                        <option value="PF"><?=$lang->country_PF?> (PF)</option>
                        <option value="TK"><?=$lang->country_TK?> (TK)</option>
                        <option value="FM"><?=$lang->country_FM?> (FM)</option>
                        <option value="MH"><?=$lang->country_MH?> (MH)</option>
                        <option value="KP"><?=$lang->country_KP?> (KP)</option>
                        <option value="HK"><?=$lang->country_HK?> (HK)</option>
                        <option value="MO"><?=$lang->country_MO?> (MO)</option>
                        <option value="KH"><?=$lang->country_KH?> (KH)</option>
                        <option value="LA"><?=$lang->country_LA?> (LA)</option>
                        <option value="BD"><?=$lang->country_BD?> (BD)</option>
                        <option value="TW"><?=$lang->country_TW?> (TW)</option>
                        <option value="MV"><?=$lang->country_MV?> (MV)</option>
                        <option value="LB"><?=$lang->country_LB?> (LB)</option>
                        <option value="JO"><?=$lang->country_JO?> (JO)</option>
                        <option value="SY"><?=$lang->country_SY?> (SY)</option>
                        <option value="IQ"><?=$lang->country_IQ?> (IQ)</option>
                        <option value="KW"><?=$lang->country_KW?> (KW)</option>
                        <option value="SA"><?=$lang->country_SA?> (SA)</option>
                        <option value="YE"><?=$lang->country_YE?> (YE)</option>
                        <option value="OM"><?=$lang->country_OM?> (OM)</option>
                        <option value="PS"><?=$lang->country_PS?> (PS)</option>
                        <option value="AE"><?=$lang->country_AE?> (AE)</option>
                        <option value="IL"><?=$lang->country_IL?> (IL)</option>
                        <option value="BH"><?=$lang->country_BH?> (BH)</option>
                        <option value="QA"><?=$lang->country_QA?> (QA)</option>
                        <option value="BT"><?=$lang->country_BT?> (BT)</option>
                        <option value="MN"><?=$lang->country_MN?> (MN)</option>
                        <option value="NP"><?=$lang->country_NP?> (NP)</option>
                        <option value="TJ"><?=$lang->country_TJ?> (TJ)</option>
                        <option value="TM"><?=$lang->country_TM?> (TM)</option>
                        <option value="AZ"><?=$lang->country_AZ?> (AZ)</option>
                        <option value="KG"><?=$lang->country_KG?> (KG)</option>
                        <option value="UZ"><?=$lang->country_UZ?> (UZ)</option>
                    </select>
                </div>
            </div>

            <div class="col-6">
                <div class=" mb-1">
                    <label class=""><?=$lang->phones?> <span class="hint-bottom-middle-t-info-s-small-mobile  hint-anim" data-hint="<?=$lang->phones_title?>">
                            <svg width="13px" height="13px" viewBox="0 0 438.533 438.533">
                                <path fill="#545454" d="M409.133,109.203c-19.608-33.592-46.205-60.189-79.798-79.796C295.736,9.801,259.058,0,219.273,0
                                c-39.781,0-76.47,9.801-110.063,29.407c-33.595,19.604-60.192,46.201-79.8,79.796C9.801,142.8,0,179.489,0,219.267
                                c0,39.78,9.804,76.463,29.407,110.062c19.607,33.592,46.204,60.189,79.799,79.798c33.597,19.605,70.283,29.407,110.063,29.407
                                s76.47-9.802,110.065-29.407c33.593-19.602,60.189-46.206,79.795-79.798c19.603-33.596,29.403-70.284,29.403-110.062
                                C438.533,179.485,428.732,142.795,409.133,109.203z M255.82,356.309c0,2.662-0.862,4.853-2.573,6.563
                                c-1.704,1.711-3.895,2.567-6.557,2.567h-54.823c-2.664,0-4.854-0.856-6.567-2.567c-1.714-1.711-2.57-3.901-2.57-6.563v-54.823
                                c0-2.662,0.855-4.853,2.57-6.563c1.713-1.708,3.903-2.563,6.567-2.563h54.823c2.662,0,4.853,0.855,6.557,2.563
                                c1.711,1.711,2.573,3.901,2.573,6.563V356.309z M325.338,187.574c-2.382,7.043-5.044,12.804-7.994,17.275
                                c-2.949,4.473-7.187,9.042-12.709,13.703c-5.51,4.663-9.891,7.996-13.135,9.998c-3.23,1.995-7.898,4.713-13.982,8.135
                                c-6.283,3.613-11.465,8.326-15.555,14.134c-4.093,5.804-6.139,10.513-6.139,14.126c0,2.67-0.862,4.859-2.574,6.571
                                c-1.707,1.711-3.897,2.566-6.56,2.566h-54.82c-2.664,0-4.854-0.855-6.567-2.566c-1.715-1.712-2.568-3.901-2.568-6.571v-10.279
                                c0-12.752,4.993-24.701,14.987-35.832c9.994-11.136,20.986-19.368,32.979-24.698c9.13-4.186,15.604-8.47,19.41-12.847
                                c3.812-4.377,5.715-10.188,5.715-17.417c0-6.283-3.572-11.897-10.711-16.849c-7.139-4.947-15.27-7.421-24.409-7.421
                                c-9.9,0-18.082,2.285-24.555,6.855c-6.283,4.565-14.465,13.322-24.554,26.263c-1.713,2.286-4.093,3.431-7.139,3.431
                                c-2.284,0-4.093-0.57-5.424-1.709L121.35,145.89c-4.377-3.427-5.138-7.422-2.286-11.991
                                c24.366-40.542,59.672-60.813,105.922-60.813c16.563,0,32.744,3.903,48.541,11.708c15.796,7.801,28.979,18.842,39.546,33.119
                                c10.554,14.272,15.845,29.787,15.845,46.537C328.904,172.824,327.71,180.529,325.338,187.574z"/>
                            </svg>
                    </span></label>
                     <input class="form_input" type="text" name="phones" value="">
                </div>
            </div>

            <div class="col-6">
                <div class=" mb-1">
                    <label class=""><?=$lang->email_for_site?></label>
                     <input class="form_input" type="text" name="email_for_site" value="">
                </div>
            </div>
        </div>
    </div>

    <div class="">
        <input type="submit" class="next_step_button" name="set_settings" value="<?=$lang->next_step?>">
    </div>
</form>

