# Маршруты (Routes)

С помощью маршрутов система узнаёт какому контроллеру нужно передать управление для обработки запроса.
Маршруты в системе прописываются в файле `Okay/Core/config/routes.php`.
 Ключ массива - это имя маршрута.
 Значение - описание маршрута.

Маршрут представляет собой массив вида:
```php
[
    'slug' => 'урл_роута{$именованный_параметр}',
    'patterns' => [
        '{$именованный_параметр}' => 'регулярное_выражение_параметра',
    ],
    'params' => [
        'controller' => 'имя_используемого_класса_контроллера',
        'method'     => 'имя_вызываемого_метода_контроллера',
    ],
    'defaults' => [
        '{$имя_параметра_по-умолчанию}' => 'значение_параметра_по-умолчанию',
    ],
    'to_front' => true|false, // нужен ли будет этот роут как JS переменная на фронте. В JS его можно будет увидеть как okay.router['<route_name>'],
    'overwrite' => true|false, // может ли этот роут переопределять роут, расположенный выше, при совпадающих названиях,
    'always_active' => true|false, // всегда активен. Когда установлено в true, даже при выключении сайта данный роут будет активен,
];
```

Пример:
```php
'cart_remove_item' => [
    'slug' => '/cart/remove/{$variantId}',
    'params' => [
        'controller' => 'CartController',
        'method' => 'removeItem',
    ],
    'patterns' => [
        '{$variantId}' => '([0-9]+)',
    ],
],
```

Все маршруты обрабатываются сверху вниз, до первого, чей slug соответствует текущему URL.
Все параметры, которые объявлены как `{$var}` и не указан для них pattern, он по умолчанию равен выражению `([^/]+)`.
Также параметры указанные как `{$var}` можно [получать в методе контроллера](./controllers.md#routeVars).

Также маршруты можно добавлять из [модуля](./modules/README.md). Для этого нужно описать маршруты по такой же структуре
как и стандартный, но в файле `Okay/Modules/Vendor/Module/Init/routes.php`.

### Генерация урлов

Роутер может на основании данных маршрута и генерировать урлы. Благодаря этому можно абстрагироваться от структуры
урлов, что делает систему более гибкой. 
Для генерации урлов в OkayCMS есть статический метод Router::generateUrl().
Метод generateUrl()
Принимает следующие аргументы:
* `$routeName` - string название маршрута, на основании которого нужно строить урл
* `$params` - array ассоциативный массив данных, которые нужно подставить в маршрут.
Ключем должно быть имя параметра. Напр. для slug `/cart/remove/{$variantId}` массив должен быть `['variantId' => 1]`
* `$isAbsolute` - bool признак абсолютного урл. По умолчанию false
* `$langId` - int id языка, для которого нужно построить маршрут. Если для текущего, можно не указывать.

Также для Smarty есть плагин-обёртка для данного метода `{url_generator}`.
Который может принимать параметры:
* `route` - string название маршрута
* `absolute` - bool|int признак абсолютного урл. По умолчанию false
* прочие параметры, которые передадутся в аргумент $params метода generateUrl().

Пример построения урла для роута `cart_remove_item` (описание выше):

PHP
```php
use Okay\Core\Router;

$url = Router::generateUrl('cart_remove_item', ['variantId' => 1], true); // http://domain.com/cart/remove/123
```

Smarty
```smarty
{url_generator route='cart_remove_item' variantId=132 absolute=1}
```

### Получение информации по текущему маршруту

Для получения информации по текущему маршруту, у класса Router есть следующие методы:
* getCurrentRouteName() - возвращает имя текущего роута
* getCurrentRouteRequiredParams() - возвращает все обязательные параметры, для которых не задан type hint (текстовые)
в виде ассоциативного массива, которые указаны в поле slug роута
* getCurrentRouteParams() - возвращает все параметры, для которых не задан type hint (текстовые)
в виде ассоциативного массива, который указаны в поле slug роута
* getRouteByName($routeName) - получить всю информацию по указанному маршруту

