# Система управления скидками

В OkayCMS реализована централизованная система управления скидками. Она позволяет управлять последовательностью и
приоритетностью применения скидок, как для корзины в целом, так и для каждого отдельного товара в корзине. Возможно
одинаково гибко настраивать и стандартные скидки (купон и пользовательская группа), и скидки созданные модулями,
при условии что они используют единый системный интерфейс для регистрации и добавления скидок в систему.

## 1. Сущность скидки

### 1.1. Виды скидки

Реализовано два базовых варианта скидки:
1)  `Абсолютная` - является скидкой выраженной в абсолютной денежной величине. Цена со скидкой никак не зависит от
    порядка применения скидок к цене.

2) `Процентная` - является скидкой выраженной в проценте. Цена со скидкой зависит от порядка применения скидок к цене.

### 1.2. Режимы вычисления скидки

У каждой скидки есть 2 режима вычисления, от которых зависит, какая цена берётся за дисконтируемую для этой конкретной
скидки:
1) `От последней скидки` - за дисконтируемую берется цена, которая получилась после расчета всех предыдущих
   скидок.

 *Пример 1:*
 
     Все 3 скидки работают в режиме `От последней скидки`
     Цена: 1000
     Скидка 1: 10%
     Скидка 2: 20%
     Скидка 3: 30%
     
     В сокращённом виде, расчёт выглядит так:
     1000 - 10% - 20% - 30%; = 504
    
     Если разбить на этапы:
     1) 1000/100*10 = 100 - скидка 1
     2) 900/100*20 = 180 - скидка 2
     3) 720/100*30 = 216 - скидка 3
     4) 1000 - 100 - 180 - 216 = 504
     
     Итоговая цена: 504

2) `От начальной цены` - за дисконтируемую берётся начальная цена.

 *Пример 2:*
 
     Все 3 скидки работают в режиме `От начальной цены`
     Цена: 1000
     Скидка 1: 10%
     Скидка 2: 20%
     Скидка 3: 30%
     
     В сокращённом виде, расчёт выглядит так:
     1000 - 1000/100*10 - 1000/100*20 - 1000/100*30; = 400
    
     Если разбить на этапы:
     1) 1000/100*10 = 100 - скидка 1
     2) 1000/100*20 = 200 - скидка 2
     3) 1000/100*30 = 300 - скидка 3
     4) 1000 - 100 - 200 - 300 = 400
     
     Итоговая цена: 400

**В случае `абсолютного` вида скидки, конечная величина скидки не будет зависеть от режима вычисления.**

Возможен вариант работы скидок с разными режимами.\
 *Пример 3:*
 
     1 и 3 скидки работают в режиме `От последней скидки`
     2 скидка работает в режиме `От начальной цены`
     Цена: 1000
     Скидка 1: 10%
     Скидка 2: 20%
     Скидка 3: 30%
     
     В сокращённом виде, расчёт выглядит так:
     1000 - 1000/100*10 - 1000/100*20 - 1000/100*30; = 400
    
     Если разбить на этапы:
     1) 1000/100*10 = 100 - скидка 1
     2) 1000/100*20 = 200 - скидка 2
     3) 700/100*30 = 210 - скидка 3
     4) 1000 - 100 - 200 - 210 = 490
     
     Итоговая цена: 490

### 1.3. Название скидки

Общие положения:
1) Должно выражать общий смысл и тематику скидки. Желательно, не больше 1-2 слов.
2) Отображается одинаково как для администратора, так и для пользователя(в корзине и на странице заказа).
3) Поле является мультиязычным.

### 1.3. Описание скидки

Общие положения:
1) Расширенная информация о скидке. Полезно, если логика формирования скидки допускает различные виды скидок под одним
   и тем же названием.
2) Стандартно, отображается только на панели администратора. При желании, можно выводить на фронте.
3) Поле является мультиязычным.

## 2. Отображение и работа со скидками

### 2.1. Панель администратора

#### 2.1.1. Управление наборами

В боковом меню выберите пункт Заказы->Скидки. Здесь расположено управление приоритетами и последовательностью вычисления
скидок для товаров в корзине и самой корзины. Эта страница отвечает за этап идущий до оформления заказа и нужна для того,
чтобы определить, какие скидки смогут быть применены к заказу пользователя.

##### 2.1.1.1 Зарегистрированные знаки скидок

В верхней части страницы расположены все зарегистрированные знаки скидок, которые поделены на 2 группы — для корзины
и для отдельной позиции в корзине. Каждый знак уникальный и представляет собой какую-либо скидку. Не путать названия
и описание находящиеся здесь с теми, что в итоге будут сохранены вместе с применённой в заказе скидкой. Тут они нужны
только для понимания администратором того, какая скидка чем является.

##### 2.1.1.2 Наборы скидок

Набор скидок представляет собой строку из знаков скидок, находящихся в том порядке, в котором они должны
вычисляться. Вместо каждого знака, в будущем, будет использоваться определённая скидка. Какие именно свойства будут у
этой скидки, будет решать система на основании введённой ниже информации и информации предоставленной модулем (или, в
случае стандартных скидок, самой системой). Как либо определить тип или значение скидки, на данном этапе,
возможности нет и данный функционал полностью ложится на внутреннюю логику модуля. Модуль, в свою очередь, может
предоставлять дополнительный интерфейс для настройки или использовать любой другой подход.

Запись каждого знака в наборе необходимо начинать с символа `$` и заканчивать пробелом(для последнего знака пробел не
требуется). По умолчанию, стандартный режим работы каждой скидки в наборе - `от последней скидки`. После открывающего
знака `$` есть возможность указать специальный символ `<`, который меняет режим работы скидки на `от начальной цены`.

*Пример 4:*

`$<ok_disc`\
Где:\
`$` - символ начала знака скидки\
`<` - символ режима работы `от начальной цены`\
`ok_disc` - знак скидки\
Всё что находится после `$`(или после `<`, если указан) и пробелом будет интерпретировано как знак скидки.

Каждый отельный набор является отдельной инструкцией и при выполнении не комбинируется с другими наборами.
Выполняется всегда только тот набор скидок, для которого, в данный момент, доступны ВСЕ указанные скидки. Самым
приоритетным для выполнения является верхний набор. В случае, если он не удовлетворяет условия, то будет использован
следующий за ним. Если и он не удовлетворяет, то следующий и так далее, до последнего, пока не будет найден подходящий.
Если ни один набор полностью не подошёл, то ни одна последовательность скидок применена не будет. Для `корзины`, весь цикл
поиска подходящего набора происходит 1 раз. Для `позиций`, этот цикл повторяется для каждой позиции отдельно и
независимо от других позиций. Доступны ли определённые скидки в каждой конкретной ситуации и может ли быть выполнен
определённый набор скидок зависит от внутренней логики модулей и самой системы.

*Пример 5:*

    Даны следующие наборы скидок:
    1. $ok_disc1
    2. $ok_disc2
    3. $ok_disc1 $ok_disc2

    Доступные скидки:
    1. $ok_disc1
    2. $ok_disc2

    Первый набор скидок является приоритетным и скидки, в нём присутствующие, доступны.
    Выполняться будет именно первый набор.

`$ok_disc1 $<ok_disc2 $ok_disc3`\
Где:\
Первая скидка - `ok_disc1`, режим работы - `от последней скидки`\
Вторая скидка - `ok_disc2`, режим работы `от начальной цены`\
Третья скидка - `ok_disc3`, режим работы `от последней скидки`

*Пример 6:*

    Дан следующий наборы скидок:
    $ok_disc1 $<ok_disc2 $ok_disc3
    Где:
    Первая скидка - ok_disc1, режим работы - от последней скидки\
    Вторая скидка - ok_disc2, режим работы от начальной цены\
    Третья скидка - ok_disc3, режим работы от последней скидки

    Значения скидок:
    ok_disc1 - 150
    ok_disc2 - 25%
    ok_disc3 - 10%
    
    Начальная цена - 1000

    В сокращённом виде, расчёт выглядит так:
    1000 - 150 - 1000/100*25 - 600/100*10; = 400
    
    Если разбить на этапы:
    1) 150 - скидка 1
    2) 1000/100*25 = 250 - скидка 2
    3) 600/100*10 = 60 - скидка 3
    4) 1000 - 150 - 250 - 60 = 540
    
    Итоговая цена: 540

Есть возможность указывать один знак скидки несколько раз. В таком случае скидка будет применяться так же, как если бы
это были 3 разные скидки. В комбинации `$ok_disc1 $ok_disc1 $ok_disc1`, одна и та же скидка будет последовательно
применена 3 раза.

##### 2.1.1.3 Использование знаков в наборах

Все зарегистрированные знаки принадлежат одной из двух сущностей: корзина или позиция;
Записанные знаки в наборе, одновременно выполняют 2 функции:
1) `Проверочная` - задаёт условие, при котором этот набор считается действительным и может быть выполнен.
2) `Испольнительная` - задаёт последовательность применения скидок.

Если в наборе для сущности использовать только знаки зарегистрированные для этой же сущности, то каждый из знаков будет
выполнять обе функции. Но в наборе, предусмотренна возможность использовать знаки зарегистрированные для другой
сущности. В таком случае, знак записанный в набор, но принадлежащий к другой сущности, будет выполнять только
`проверочную` функцию, а значит будет учитываться на этапе проверки набора, но игнорироваться на этапе применения.

Для корзины и позиций алгоритм проверки будет немного отличаться.

###### Набор для корзины
1) Все указанные скидки корзины должны быть доступны для корзины. 
2) Каждая из указанных скидок позиции должна быть доступна хотя бы в одной из позиций корзины.

###### Набор для позиции
1) Все указанные скидки позиции должны быть доступны для конкретной позиции(помним, что для каждой позиции поиск
подходящего набора происходит независимо, путём перебора от первого до последнего. И при различных доступных скидках, для
каждой позиции может быть применён разный набор).
2) Все указанные скидки корзины должны быть доступны для корзины.

#### 2.1.2. Работа со скидками в заказе

На странице работы с заказом есть возможность менять параметры созданных сикдок, менять очерёдность применения,
удалять скидки, или добавлять новые. При сохранении изменённого заказа, произойдёт перерасчёт стоимости заказа с учётом
изменённых скидок.

### 2.2. Сайт

На странице корзины и во всплывающей корзине, отображаются доступные для пользователя скидки, при условии, что выполняется
хотя бы один набор скидок. Именно скидки из этого набора будут видны пользователю и, в последствии, использованы при
оформлении заказа. У пользователя нет возможности напрямую влиять на выбор какого-либо набора, узнать какой набор был
применён к нему, менять набор или получить информацию о других возможных наборах. После оформления заказа, пользователь
сможет видеть применённые скидки на странице заказа.

## 3. Создание своих скидок в системе

При разработке модуля, в систему можно добавлять свои скидки, которые потом можно будет настраивать через страницу
управления скидками.

## 3.1. Регистрация знака скидки

Предварительно, скидку необходимо зарегистрировать в системе. Регистрация происходит через вызов методов
[registerPurchaseDiscountSign()](./modules/init.md#registerPurchaseDiscountSign) (для позиции) или
[registerCartDiscountSign()](./modules/init.md#registerCartDiscountSign) (для корзины) в методе `init()` класса
[Init](./modules/init.md).
Необходимо указать знак скидки, название и описание для страницы управления скидками. Название и описание должны задаваться
через языковую переменную в файлах переводов. Для этого, в файлах backend переводов создайте новый перевод, а его
название используйте в качестве названия скидки при регистрации.

*Пример 7:*

```php
//Backend/lang/ru.php:
$lang['discount_coupon_name'] = 'Купон';
$lang['discount_coupon_description'] = 'Купон, который пользователь вводит в корзине.';
```

```php
class Init extends AbstractInit {
    public function init()
    {
        //...abstract 
        $this->registerCartDiscountSign(
            'ok_coup',
            'discount_coupon_name',
            'discount_coupon_description'
        );
        //...abstract 
    }
}
```

Так же, регистрацию можно выполнять в любом месте используя методы `registerPurchaseSign()` и `registerCartSign()` класса
`Discounts.php`

## 3.2. Добавление скидки

Для того, чтобы скидка была доступна и мог быть применён набор её включающий, её необходимо добавить, либо в саму
корзину, либо в определённую позицию, через вызов свойства `availableDiscounts` и добавление в этот массив, используя в качестве
ключа знак скидки. Добавление должно происходить через расширение метода `attachDiscounts()` класса `Okay/Core/Cart.php`.

Скидка должна являться объектом класса [Discount](./core/Discount.md).

Обязательными для указания являются свойства `sign`, `value` и `type`(absolute - абсолютная, percent - процентная).

Опциональным является свойство `fromLastDiscount`. Если не задано, будет учитываться то, что написано в `наборе`.

Свойства `name` и `description` - языковые переменные, которые берутся с frontend переводов. Эти значения переводов
будут сохранены в базу и будут мультиязычными. Если не заданы, то берутся переменные указаные при регистрации знака скидки.
ВНИМАНИЕ! Берутся только переменные, а не сами переводы. Это значит, что если при регистрации было указано название перевода
`discount_coupon_name`, а потом не переопределено в момент добавления скидки то перевод с таким же названием будет искаться
в frontend переводах. Это позволяет не дублировать код, если переводы названия и/или описания называются одинаково на backend и frontend.\
Так как переводы это статические данные, есть возможность добавить в них динамические. Для этого необходимо в переводе
(обязательно, строка в одинарных кавычках) указать переменную в формате `{$coupon}`, а у `discount` в массив `langParts` добавить
элемент, ключом которого будет эта переменная, а значение будет определяться динамически.

В Примере 8 мы создали переводы для backend и frontend. Зарегистрировали скидку для корзины в методе `init()`, добавили `extension`
для метода 'attachDiscounts' и в `FrontendExtender` добавили в корзину нашу скидку. Теперь, если набор, который
использует, например, только эту скидку получит наивысший приоритет, то эта скидка будет применена к корзине.

*Пример 8:*

```php
//Backend/lang/ru.php:

$lang['discount_coupon_name'] = 'Купон';
$lang['discount_coupon_description'] = 'Купон, который пользователь вводит в корзине.';
```
```php
//design/lang/ru.php:

$lang['discount_coupon_name'] = 'Купон';
$lang['discount_coupon_description'] = 'Назване купона {$coupon}';
```
```php
class Init extends AbstractInit {
    public function init()
    {
        //...abstract 
        $this->registerCartDiscountSign(
            'ok_coup',
            'discount_coupon_name',
            'discount_coupon_description'
        );
        
        $this->registerChainExtension(
            [Cart::class, 'attachDiscounts'],
            [FrontendExtender::class, 'attachDiscounts']
        );
        //...abstract 
    }
}
```
```php
class FrontendExtender implements ExtensionInterface
{

    //...abstract 
    public function attachDiscounts($cart)
    {
        $discount = new Discount();
        $discount->sign = 'ok_coup';
        $discount->type = 'absolute';
        $discount->value = 100;
        $discount->langParts['coupon'] = $_SESSION['coupon_code'];
        $cart->availableDiscounts['ok_coup'] = $discount;
    
        return $cart;
    }
    //...abstract 
}
```