# Контроллеры

Контроллеры в OkayCMS нужны для обработки маршрутов.
Контроллеры делятся на фронт-контроллеры (клиентская часть) и бек-контроллеры (админ часть).
Также эти контроллеры делятся на стандартные (которые присутствуют в системе по умолчанию) и модульные (которые
добавляются из модулей).

Общий порядок работы контроллеров. 
Сразу зайдя на страницу роутер создает экземпляр контроллера, затем вызывает
метод `onInit` после него вызывает метод контроллера, указанный в роуте.

В методе контроллера стоит установить контент, который должен возвращаться пользователю. Для этого вызовите метод
[Response::setContent()](./core/Response.md#setContent).

### Фронт-контроллеры <a name="frontControllers"></a>

По умолчанию контроллеры лежат в неймспейсе `Okay\Controllers\` и МОГУТ наследоваться от 
`Okay\Controllers\AbstractController`.

В большинстве случаем желательно наследоваться от AbstractController, чтобы у вас уже был проинициализирован дизайн,
валюты, языки etc. 
Но в случае, когда нужно сделать "лёгкий" контроллер (например для обработки не сложных ajax запросов), можно
не наследоваться, но в таком случае если нужен дизайн или еще что-то что инициализировалось в AbstractController,
его нужно получать отдельно в методе контроллера через [инъекцию зависимости](./di_container.md#GetService).
Также можно определить свои методы onInit() и afterController().

В контроллере может быть описано несколько методов, и несколько [роутов](./routes.md) может ссылаться на разные 
методы одного контроллера.

#### Получение сервисов из контейнера <a name="DIVars"></a>

В методе контроллера можно получать в виде зависимостей экземпляры классов [ядра](./core/README.md), [хелперов](./helpers.md),
[реквесты](./requests.md), [entity](./entities.md), а также параметры, указанные в [роуте](./routes.md). 
Чтобы получить экземпляр определённого класса, нужно принять в методе контроллера аргумент, с указанием type hint,
и система автоматически передаст туда экземпляр запрашиваемого класса.

Например:
```php
namespace Okay\Controllers;

use Okay\Entities\BlogEntity;
use Okay\Helpers\CommentsHelper;

class BlogController extends AbstractController
{
    public function fetchPost(
        BlogEntity $blogEntity,
        CommentsHelper $commentsHelper
    ) {
        //...abstract
    }
}
```

#### Получение параметров из марштута <a name="routeVars"></a>

Чтобы получить параметры из [маршрута](./routes.md) в контроллере, нужно в методе контроллера указать аргумент,
одноимённый с параметром маршрута (указанным в поле slug), при этом type hint не указывается.
Если роут предполагает что параметр является опциональным, в методе стоит ему тоже задать значение по умолчанию.

Например для slug роута `/cart/{$variantId}` в методе можно ловить переменную `$variantId`

Пример:
```php
namespace Okay\Controllers;

use Okay\Core\Cart;

class CartController extends AbstractController
{
    public function addItem(Cart $cartCore, $variantId)
    {
        //...abstract
    }
}
```

### Бек-контроллеры <a name="backendControllers"></a>

Контроллеры админ-части по умолчанию лежат в неймспейсе `Okay\Admin\Controllers` (это директория `backend/Controllers`).
Все контроллеры админки должны наследоваться от `Okay\Admin\Controllers\IndexAdmin`.
У контроллеров админ-части по умолчанию вызывается метод `fetch()`.
Если нужно вызвать другой метод контроллера, нужно в урле название контроллера указать как ControllerName@methodName.
Например: `backend/index.php?controller=OrdersAdmin@myFunc` вызовется метод myFunc контроллера OrdersAdmin.
Имя метода может содержать только символы `a-zA-Z0-9`
Зависимости можно получать также, как и для [фронт-контроллеров](#DIVars). Параметров маршрута для контроллера админки
не бывает. Разве что $_GET параметры.

### Фронт-контроллеры модулей

Контроллеры модулей стоит размещать в директории `Okay/Modules/Vendor/Module/Controllers`, в остальном, они ничем не
отличаются от [стандартных фронт-контроллеров](#frontControllers). Роут к ним также прописывается в [файле 
`Init/routes.php`](./modules/README.md#configuratinFiles).

### Бек-контроллеры модулей <a name="backendControllersModules"></a>

Бек-контроллеры модулей, полностью соответствуют [стандартным бек-контроллерам](#backendControllers), но располагаются
в директории `Okay/Modules/Vendor/Module/Backend/Controllers`.
Еще одно отличие в использовании: стандартный контроллер в админ панели доступен по урлу 
`https://demookay.com/backend/?controller=ProductsAdmin`, контроллеры модулей имеют немного инной формат.
Название контроллера должно состоять из имени поставщика, имени модуля и названия самого контроллера разделённых точкой.

Например: `https://demookay.com/backend/index.php?controller=OkayCMS.FAQ.FAQsAdmin`, об этом стоит помнить, когда пишете
URL на контроллер в tpl файле модуля.